###########################################
# Event Scheduler v1.0 3-13-04		#
# Copyright  2004 Super Powio		#
# Powio@SunAndShadows.com			#
# www.SunAndShadows.com/MIB			#
###########################################

// This script is an alternative to Starsiege's built in schedule() command.
// Like schedule(), EventStdLib takes commands to execute after a given
// peroid in time. However unlike schedule(), these Events may be toggled
// to run, or be executed prematurely  a feature that wasn't available with
// the schedule command.
//
// USAGE:
// Event::Add( command , deltaTime ):	Runs a command in the given amount of time (seconds). Returns an integer (event index).
// Event::Enabled( index , True/False ):	Turns an event on or off. Index is the event index number.
// Event::Play( index ):			Plays an event. Runs automatically, but can be used prematurely. Turns the event off afterwards.
// Event::Reset():				Clears the Event Schedule. Recommend running at the beginning of a map. WARNING: STOPS ALL SCHEDULE() COMMANDS.
// Event::isClear():				Returns TRUE if the Event Schedule is empty.
//
// NOTES:
// - Please do not use Event::Remove(). This function should only be run by the script.
// - When an Event is automatically executed, it is deleted from the Event Schedule. This is not the same as disabling it.
//----------------------------------------- 

// Event Functionality
function Event::Reset()
{
	flushConsoleScheduler();
	deleteVariables("$Event*");
	$Event::MaxIndex = -1;

	echo( "Event::Reset(): All events have been reset." );
}

function Event::Add(%command, %time)
{
	if(%time == "")
	{
		echo( "Event::Add(): command (str), deltaTime" );
	}

	else
	{
		for(%i = 0; %i <= $Event::MaxIndex; %i++)			// Find an empty index to set the ID to.
		{
			if($Event::Enabled[%i] == "")
			{
				%index = %i;
				break;
			}
		}

		if(%index == "")						// If there are no empty slots, make a new one and set the new Max Index.
		{
			$Event::MaxIndex++;
			%index = $Event::MaxIndex;
		}

		$Event::Command[%index] = %command;
		$Event::Enabled[%index] = TRUE;
		schedule("	Event::Play( " @ %index @ " ); Event::Remove( " @ %index @ " ); " , %time );	// Event::Remove used to be embedded in the Event::Play command, but now it's called seperately to allow events to be called prematurely.

		return %index;						// Return the ID in case its attributes need to be changed later.
	}
}

function Event::Enable(%index, %bool)
{
	if( %index == "" || ( %bool != TRUE && %bool != FALSE ) )
	{
		echo( "Event::Enable( eventIndex , true/false )" );
	}
	else if(%index < 0)
	{
		echo( "Event::Enable(): Index cannot be less than 0" );
	}

	else
	{
		if( $Event::Enabled[ %index ] != TRUE && $Event::Enabled[ %index ] != FALSE )
		{
			echo( "Event::Enable(): Bad boolean in event " @ %index );
		}

		else
		{
			$Event::Enabled[ %index ] = %bool;
		}
	}
}

function Event::Remove( %index )
{
	if(%index == "")
	{
		echo("Event::Remove( eventIndex )");
	}
	else if(%index < 0)
	{
		echo("Event::Remove(): Index cannot be less than 0");
	}

	else
	{
		$Event::Command[ %index ] = "";
		$Event::Enabled[ %index ] = "";
		Event::ResetMaxIndex();
	}
}

function Event::ResetMaxIndex()
{
	for(%i = $Event::MaxIndex; %i >= 0; %i--)			// Find an empty index to set the ID to.
	{
		if( $Event::Enabled[%i] != "" )
		{
			$Event::MaxIndex = %i;
			return;
		}
	}

	$Event::MaxIndex = -1;						// If all the slots are empty, set the Max Index to -1.
}

function Event::Play( %index )
{
	if(%index == "")
	{
		echo("Event::Play( eventIndex )");
	}

	else 
	{
		if( $Event::Enabled[ %index ] != TRUE && $Event::Enabled[ %index ] != FALSE )
		{
			echo( "Event::Play(): Bad boolean in event " @ %index );
		}

		else if($Event::Enabled[ %index ] == TRUE)
		{
			eval( $Event::Command[ %index ] );
			Event::Enable(%index, FALSE);
		}
	}
}

function Event::isClear()
{
	if($Event::MaxIndex == -1)
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}